SparkFun Inventor's Kit - Example Sketches
======================================================

[![SparkFun Inventor's Kit](https://cdn.sparkfun.com/assets/parts/1/1/7/0/8/12060-01.jpg)  
*SparkFun Inventor's Kit (KIT-13969)*](https://www.sparkfun.com/products/13969)

The example sketches in this repository are part of the SparkFun Inventor's Kit (a.k.a. *"The SIK"*). 
The SIK consists of an [Arduino microcontroller](http://www.arduino.com) and a variety of electronic components designed to help you learn basic programming and circuits. 
Once you've mastered these circuits, you'll be able to start building projects limited only by your imagination!

These sketches are designed to work with the [SIK Experiment Guide](https://learn.sparkfun.com/tutorials/sik-experiment-guide-for-arduino---v33) tutorial. 


Getting Started
---------------

1. If you haven't yet, download and install the [Arduino IDE](http://arduino.cc/en/Main/Software)
2. Obtain the latest SIK Guide Code by one of the following methods:
 * Clone this repository using Git ([New to Git? Click here.](https://help.github.com/articles/set-up-git))
 * Download this repository as a [zip file](https://github.com/sparkfun/SIK-Guide-Code/archive/master.zip) and unzip.
3. Place the `SIK-Guide-Code` folder in the Arduino IDE `examples` directory:
 * PC: drag the `SIK-Guide-Code` folder into `C:\program files\Arduino-x\examples`
 * MAC: Right-click on the Arduino IDE app and click "Show Package Contents...". Drag the `SIK-Guide-Code` folder into `Contents/Resources/Java`
 * Linux: see [http://www.arduino.cc/playground/Learning/Linux](http://www.arduino.cc/playground/Learning/Linux)
4. Start the Arduino IDE; the examples should be visible in this menu: `File > Examples > SIK Guide Code`

Sketch Topics
-------------

1.  Blinking an LED
2.  Potentiometer (knob)
3.  RGB (Red Green Blue) LED
4.  Multiple LEDs
5.  Push buttons
6.  Photoresistor (light sensor)
7.  Temperature sensor
8.  Servomotor
9.  Flex sensor
10. Soft potentiometer
11. Buzzer
12. Motor
13. Relay
14. Shift register
15. Using an LCD
16. Simon Says

Documentation
--------------
* **[Hookup Guide](https://learn.sparkfun.com/tutorials/sik-experiment-guide-for-arduino---v33)** - Experiment Guide for the SIK.

Version History
---------------
* [v33](https://github.com/sparkfun/SIK-Guide-Code/tree/v33) -SIK code version 3.3
* [v32](https://github.com/sparkfun/SIK-Guide-Code/tree/v32) -SIK code version 3.2
* [v30](https://github.com/sparkfun/SIK-Guide-Code/tree/v30) -SIK code version 3.0



License Information
-------------------

These sketches were written by [SparkFun Electronics](https://www.sparkfun.com) with lots of help from the Arduino community.

All contents of this repository are released under [Creative Commons Share-alike 3.0](http://creativecommons.org/licenses/by-sa/3.0/).
